function MyResult=Decompos(MySq, DecomExpWidth,DecomposRatio,k)
%  object should have only 4 points
% DecomposRatio >1 is ratio how much average explosure will reduce, 

DecomposExpWidth=DecomExpWidth*k;
DecomposNonWidth=DecomposExpWidth*(DecomposRatio-1);



% normal vector parallel to 12
x12a=MySq(2,:)-MySq(1,:); x12=x12a/sqrt(x12a(1)^2+x12a(2)^2);;
% normal vector perpend to 12
per=[x12(2) x12(1)];
% normal vector parallel to 14
x14a=MySq(4,:)-MySq(1,:); a14=sqrt(x14a(1)^2+x14a(2)^2);x14=x14a/a14;;
% normal vector parallel to 23
x23a=MySq(3,:)-MySq(2,:); a23=sqrt(x23a(1)^2+x23a(2)^2);x23=x23a/a23;;
%%%%%%%%%%%%%%%%%%%%
%check that 12 and 14 have small angle
cos14=abs(per*x14');
cos23=abs(per*x23');




MyMin=a14*cos14; MyMin2=a23*cos23; 
if MyMin2<MyMin
    MyMin=MyMin2; 
end

MyOutStep=floor(MyMin/(DecomposExpWidth+DecomposNonWidth));
LeftOver=MyMin-MyOutStep*(DecomposExpWidth+DecomposNonWidth)+DecomposNonWidth;

xout=MySq(1,:); yout=MySq(2,:);
    xout=xout+LeftOver/2*x14/cos14;
    yout=yout+LeftOver/2*x23/cos23;
j1=0;
for j=1:MyOutStep
    j1=j1+1;
    xin=xout+DecomposExpWidth*x14/cos14;
    yin=yout+DecomposExpWidth*x23/cos23;

    

AllInLine=[xout; yout; yin; xin ];
   AllInLine=round(AllInLine);
   
 MyResult{j1}=AllInLine;clear AllInLine;
 
    xout=xin+DecomposNonWidth*x14/cos14;
    yout=yin+DecomposNonWidth*x23/cos23;
 
end




    
